<?php
  session_start();
  
  function readData()
  {
    $dsn = "mysql:host=localhost;dbname=testphp";
    $uzytkownik = "php";
    $haslo = "test";

    try{
      $dbo = new PDO($dsn, $uzytkownik, $haslo);
    }
    catch (PDOException $e){
      //echo 'Błąd połączenia: ' . $e->getMessage();
      return false;
    }

    $query = 'SELECT SUM(Glosy) FROM kolory';
    if(!$result = $dbo->query($query)){
      //echo "Błąd w zapytaniu SELECT SUM";
      return false;
    }

    if(!$row = $result->fetch(PDO::FETCH_NUM)){
      //echo "Błąd przy przetwarzaniu wyników pierwszego zapytania SELECT";
      echo "Wyniki ankiety nie są w tej chwili dostępne.";
      return false;
    }
    
    $votes_no = $row[0];

    $query = "SELECT Kolor, Glosy, Glosy * 100 / $votes_no";
    $query .= " AS Proc FROM kolory ORDER BY Glosy DESC";

    if(!$result = $dbo->query($query)){
      //echo "Błąd w drugim zapytaniu SELECT";
      return false;
    }

    return $result->fetchAll(PDO::FETCH_NUM);
  }
  
  if(isset($_SESSION['komunikat'])){
    $komunikat = $_SESSION['komunikat'];
    unset($_SESSION['komunikat']);
  } else {
    $komunikat = false;
  }
  
  $glosy = readData();
?>

<!DOCTYPE html>
<html>
  <head>
    <meta charset="utf-8">
    <title>Moja strona WWW</title>
  </head>
  <body>
    <?php
      if($komunikat){
        echo "<p>$komunikat</p>";
      }
    ?>
    <h3>Wyniki sondy</h3>
    <?php
      if($glosy):
    ?>
      <table border='1'>
        <tr>
          <td>Nazwa koloru</td>
          <td>Liczba głosów</td>
          <td>Procent głosów</td>
        </tr>
    <?php foreach($glosy as $row): ?>
        <tr>
          <td><?=$row[0]?></td>
          <td><?=$row[1]?></td>
          <td><?=$row[2]?></td>
        </tr>
    <?php endforeach; ?>  
      </table>
    <?php
      else:
        echo "<p>Wyniki głosowania nie są w tej chwili dostępne.</p>";
      endif;
    ?>
    <p><a href="ankieta.html">Powrót do sondy</a></p>
</body>
</html>
